package org.krproject.ocean.vitamins.param.service.inner;

import java.util.Map;

/**
 * 参数访问服务接口.
 * @author zhongyang
 *
 */
public interface ParamAccessService {
	
	/**
	 * 获取单个参数.
	 * @param <T> 参数泛型
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @param key 参数键值
	 * @param paramStoreService 存储服务接口
	 * @return ParamModel 参数模型
	 */
	<T> T getParameter(String orgId, String paramClass, String key, ParamStoreService paramStoreService);
	
	/**
	 * 获取类型参数.
	 * @param <T> 参数泛型
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @param paramStoreService 存储服务接口
	 * @return Map 参数实体集合
	 */
	<T> Map<String, T> getParameterMap(String orgId, String paramClass, ParamStoreService paramStoreService);
	
	
	/**
	 * 参数改变处理.
	 * @param orgId 机构号
	 * @param paramClass 参数类名
	 * @param key 参数键值
	 */
	void onChangedParameter(String orgId, String paramClass, String key);
}
