package org.krproject.ocean.vitamins.param.exception;


/**
 * 错误代码.
 * 
 * @author Tiger
 *
 */
public enum ErrorCode {
	
	/**
	 * 参数不存在.
	 */
	PARAM_NOT_FOUND("1000"),

	/**
	 * 参数已存在.
	 */
	PARAM_ALREADY_EXISTS("1003"),

	/**
	 * 参数解析异常.
	 */
	PARAM_PARSE_ERROR("1001"),
	
	/**
	 * 参数class不存在.
	 */
	PARAM_CLASS_NOT_FOUND("1004"),
	
	/**
	 * 系统异常异常.
	 */
	PARAM_SYSTEM_ERROR("9999");
	
	
	// 对应外部响应码
	private String respCode;
	
	ErrorCode(String respCode) {
		this.setRespCode(respCode);
	}

	public String getRespCode() {
		return this.respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

}
