package org.krproject.ocean.vitamins.param.event;

import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;
import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 参数通知事件.
 * @author zhongyang
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class ParamChangedEvent extends ApplicationEvent {
	
	public ParamChangedEvent(Object source, String orgId, String paramClass, String paramKey, ParamOperationEnum paramOperation) {
		super(source);
		this.orgId = orgId;
		this.paramClass = paramClass;
		this.paramKey = paramKey;
		this.paramOperation = paramOperation;
	}
	
	/**
	 * 机构号.
	 */
	private String orgId;
	
	/**
	 * 参数类名.
	 */
	private String paramClass;

	/**
	 * 参数key.
	 */
	private String paramKey;
	
	/**
	 * 参数操作类型.
	 */
	private ParamOperationEnum paramOperation;

}
