package org.krproject.ocean.vitamins.param.domain;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

import lombok.Data;


/**
 * 参数对象实体.
 * @author zhongyang
 *
 */
@Data
@Entity
@Table(name = "PARAM_OBJECT", indexes = {
		@Index(name = "IDX_PARAM_OBJECT_1", columnList = "ORG_ID, PARAM_CLASS, PARAM_KEY", unique = true)
})
public class ParamObjectEntity {
	
	//对象编号
	@Id
	@GeneratedValue(generator = "SEQ_PARAM_OBJECT")
	@GenericGenerator(name = "SEQ_PARAM_OBJECT", strategy = "org.hibernate.id.enhanced.SequenceStyleGenerator", 
		parameters = {
			@Parameter(name = "sequence_name", value = "SEQ_PARAM_OBJECT")
		}
	)
	@Column(name = "OBJECT_ID", nullable = false, precision = 20, scale = 0)
	private BigDecimal objectId;
	
	//机构编号
	@Column(name = "ORG_ID", nullable = false, length = 12)
	private String orgId;

	//参数类名
	@Column(name = "PARAM_CLASS", nullable = false, length = 200)
	private String paramClass;

	//参数键值
	@Column(name = "PARAM_KEY", nullable = false, length = 100)
	private String paramKey;
    
	//参数对象
	@Lob
	@Column(name = "PARAM_OBJECT", nullable = false, length = 1048576)
	private String paramObject;

	//维护人员
	@Column(name = "MTN_USER", nullable = true, length = 40)
	private String mtnUser;
    
	//创建时间（手动维护）
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CREATE_TIME", nullable = true)
	private Date createTime;
    
	//最后更新时间（手动维护）
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "LAST_UPDATE_TIME", nullable = true)
	private Date lastUpdateTime;

	//乐观锁版本号
	@Version
	@Column(name = "JPA_VERSION", nullable = true)
	private Integer jpaVersion;

}
