package org.krproject.ocean.vitamins.param.domain;

import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;

import lombok.Data;


/**
 * 参数审计实体.
 * @author zhongyang
 *
 */
@Data
@Entity
@Table(name = "PARAM_AUDIT", indexes = {
		@Index(name = "IDX_PARAM_AUDIT_1", columnList = "PARAM_CLASS", unique = false)
})
public class ParamAuditEntity {
	
	//审计编号
	@Id
	@GeneratedValue(generator = "SEQ_PARAM_AUDIT")
	@GenericGenerator(name = "SEQ_PARAM_AUDIT", strategy = "org.hibernate.id.enhanced.SequenceStyleGenerator", 
		parameters = {
			@Parameter(name = "sequence_name", value = "SEQ_PARAM_AUDIT")
		}
	)
	@Column(name = "AUDIT_ID", nullable = false, precision = 20, scale = 0)
	private BigDecimal auditId;

	//机构编号
	@Column(name = "ORG_ID", nullable = false, length = 12)
	private String orgId;
	
	//参数类名
	@Column(name = "PARAM_CLASS", nullable = false, length = 200)
	private String paramClass;

	//参数键值
	@Column(name = "PARAM_KEY", nullable = false, length = 100)
	private String paramKey;

	//参数操作类型
	@Enumerated(EnumType.STRING)
	@Column(name = "PARAM_OPERATION", nullable = false, length = 10)
	private ParamOperationEnum paramOperation;
	
	//原参数对象
	@Lob
	@Column(name = "OLD_OBJECT", nullable = true, length = 1048576)
	private String oldObject;
	
	//现参数对象
	@Lob
	@Column(name = "NEW_OBJECT", nullable = true, length = 1048576)
	private String newObject;
	
	//维护用户
	@Column(name = "MTN_USER", nullable = true, length = 40)
	private String mtnUser;

	//维护备注
	@Column(name = "MTN_MEMO", nullable = true, length = 200)
	private String mtnMemo;

	//创建时间
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "CREATE_TIME", nullable = true)
	private Date createTime;
	
	//乐观锁版本号
	@Version
	@Column(name = "JPA_VERSION", nullable = false)
	private Integer jpaVersion;

}
