package org.krproject.ocean.vitamins.online.api;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;


/**
 * 联机请求抽象基类.
 * 
 * @param <T> 响应
 * 
 * @author Tiger
 *
 */
@Data
@SuppressWarnings("serial")
public abstract class OnlineRequest<T extends OnlineResponse> implements Serializable {

	@JsonIgnore
	@SuppressWarnings("unchecked")
	public Class<T> getResponseClass() {
		Class<T> tClass = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	public T createResponse() {
		T response = null;
		try {
			response = this.getResponseClass().newInstance();
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return response;
	}
	
}
