package org.krproject.ocean.vitamins.batch.api.enums;

/**
 * 批量服务交易状态.
 * 
 * @author zhongyang
 *
 */
public enum BatchRespCodeEnum {
	
	/**
	 * 交易成功.
	 */
	SUCCESS("0000"),
	
	/**
	 * 处理中.
	 */
	PROCESSING("0001"),
	
	/**
	 * 交易失败.
	 */
	FAILURE("0002"),
	
	/**
	 * 请求不合法.
	 */
	BAD_REQUEST("9001"),

	/**
	 * 系统错误.
	 */
	SYSTEM_ERROR("9999");
	
	private String respCode;
	
	BatchRespCodeEnum(String respCode) {
		this.respCode = respCode;
	}

	public String getRespCode() {
		return this.respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

}
