package org.krproject.ocean.vitamins.admin.service.impl;

import org.krproject.ocean.vitamins.admin.model.app.AppUserVo;
import org.krproject.ocean.vitamins.admin.service.AdminAppService;
import org.krproject.ocean.vitamins.admin.service.AdminSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;


/**
 * App服务实现. 
 * 
 * @author Tiger
 *
 */
@Service
public class AdminAppServiceImpl implements AdminAppService {
	
	@Autowired
	private AdminSecurityService adminSecurityService;
	
	@Override
	public AppUserVo getUser(String username) {
		return new UserConverter().convert(this.adminSecurityService.loadUserByUsername(username));
	}

	/**
	 * 将数据库实体类DO转为展示对象VO.
	 * 
	 * @author Tiger
	 */
	private class UserConverter implements Converter<UserDetails, AppUserVo> {

		@Override
		public AppUserVo convert(UserDetails user) {
			if (user != null) {
				AppUserVo appUserVo = new AppUserVo();
				appUserVo.setId(user.getUsername());
				if (user.getAuthorities() != null && !user.getAuthorities().isEmpty()) {
					for (GrantedAuthority auth : user.getAuthorities()) {
						appUserVo.getAuthorities().add(auth.getAuthority());
					}
				}
				return appUserVo;
			}
			return null;
		}
	}

}
