package org.krproject.ocean.vitamins.admin.model.param;

import java.io.Serializable;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 参数信息.
 * 
 * @author Tiger
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
@Schema(description = "参数信息")
public class ParamVo implements Serializable {
	
	@Schema(description = "分支编号", required = true)
	private String orgId;
	
	@Schema(description = "参数类名", required = true)
	private String paramClassName;
	
	@Schema(description = "参数键", required = true)
	private String paramKey;
	
	@Schema(description = "参数值", required = true)
	private String paramObject;
	
	@Schema(description = "维护人员", required = true)
	private String mtnUser;
}
