package org.krproject.ocean.vitamins.admin.model.param;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 参数审计信息.
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
@Schema(description = "参数审计信息")
public class ParamAuditVo implements Serializable {
	
	@Schema(description = "主键", required = true)
	private BigDecimal auditId;
	
	@Schema(description = "机构号", required = true)
	private String orgId;
	
	@Schema(description = "参数类名", required = true)
	private String paramClass;
	
	@Schema(description = "参数键值", required = true)
	private String paramKey;
	
	@Schema(description = "参数操作类型", required = true)
	private ParamOperationEnum paramOperation;
	
	@Schema(description = "原参数", required = true)
	private String oldObject;
	
	@Schema(description = "现参数", required = true)
	private String newObject;
	
	@Schema(description = "维护用户", required = true)
	private String mtnUser;
	
	@Schema(description = "维护备注", required = true)
	private String mtnMemo;
	
	@Schema(description = "创建时间", required = true)
	private Date createTime;

}
