package org.krproject.ocean.vitamins.admin.model;

import java.io.Serializable;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 响应类.
 * 
 * @author Tiger
 */
@Data
@Schema(description = "响应类")
@SuppressWarnings("serial")
public class AdminResponse implements Serializable {
	
	@Schema(description = "响应码", required = true)
	private String code;
	
	@Schema(description = "响应描述", required = true)
	private String message;
	
	@Schema(description = "响应体", required = true)
	private Object data;
	
	public AdminResponse() {
		this.code = AdminRespCode.SUCCESS.getCode();
		this.message = AdminRespCode.SUCCESS.toString();
	}
	
	public AdminResponse(Object object) {
		this.code = AdminRespCode.SUCCESS.getCode();
		this.message = AdminRespCode.SUCCESS.toString();
		this.data = object;
	}
	
	public AdminResponse(String code, String message, Object data) {
		this.code = code;
		this.message = message;
		this.data = data;
	}
	
	public AdminResponse(AdminRespCode respCode, String message) {
		this.code = respCode.getCode();
		this.message = message;
	}
	
	public AdminResponse(AdminRespCode respCode, String message, Object data) {
		this.code = respCode.getCode();
		this.message = message;
		this.data = data;
	}
}
