package org.krproject.ocean.vitamins.admin.interceptor;

import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.krproject.ocean.vitamins.admin.event.AdminAuditEvent;
import org.krproject.ocean.vitamins.service.config.ServiceProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;


/**
 * 审计日志记录拦截器.
 * 
 * @author Tiger
 */
@Component
public class AdminAuditInterceptor implements HandlerInterceptor {

	@Autowired
	private ServiceProperties serviceProperties;

	@Autowired
	private ApplicationContext applicationContext;

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
			throws Exception {
		if (handler instanceof HandlerMethod) {
			RequestMapping rm = ((HandlerMethod) handler).getMethod().getAnnotation(RequestMapping.class);
			if (rm != null) {
				request.setAttribute("PRE_HANDLE_TIME", new Date());
			}
		}
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
			ModelAndView modelAndView) throws Exception {
		if (handler instanceof HandlerMethod) {
			RequestMapping rm = ((HandlerMethod) handler).getMethod().getAnnotation(RequestMapping.class);
			if (rm != null) {
				request.setAttribute("POST_HANDLE_TIME", new Date());
			}	
		}
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex)
			throws Exception {
		Authentication auth = SecurityContextHolder.getContext().getAuthentication();
		if (auth != null && auth.isAuthenticated() && handler instanceof HandlerMethod) {
			AdminAuditEvent event = new AdminAuditEvent(this);
			event.setInstanceId(this.serviceProperties.getInstanceId());
			event.setOperator(auth.getName());
			String ipAddress = request.getHeader("X-FORWARDED-FOR"); // proxy
			if (ipAddress == null) {
				ipAddress = request.getRemoteAddr();
			}
			event.setRemoteAddr(ipAddress);
			event.setRequestURI(request.getRequestURI());
			event.setRequestMethod(request.getMethod());
			event.setRequestParam(request.getQueryString()); // you need url decode this
			event.setPreHandleTime((Date) request.getAttribute("PRE_HANDLE_TIME"));
			event.setPostHandleTime((Date) request.getAttribute("POST_HANDLE_TIME"));
			RequestMapping rm = ((HandlerMethod) handler).getMethod().getAnnotation(RequestMapping.class);
			if (rm != null) {
				event.setHandlerDesc(rm.name()); // use RequestMapping name property
			}
			this.applicationContext.publishEvent(event);
		}
	}
}
