package org.krproject.ocean.vitamins.admin.exception;

import org.krproject.ocean.vitamins.admin.model.AdminRespCode;

/**
 * Admin统一异常定义.
 * 
 * @author Tiger
 *
 */
@SuppressWarnings("serial")
public class AdminException extends RuntimeException {
	
	private final AdminRespCode respCode;
	
	public AdminException(AdminRespCode respCode, String errorDesc) {
		super(errorDesc);
		this.respCode = respCode;
	}
	
	public AdminException(AdminRespCode respCode) {
		this.respCode = respCode;
	}

	public AdminException(Throwable cause) {
		super(cause);
		this.respCode = null;
	}

	public AdminRespCode getRespCode() {
		return this.respCode;
	}
}
