package org.krproject.ocean.vitamins.admin.event;

import java.util.Date;

import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 后管审计事件.
 * 
 * @author Tiger
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class AdminAuditEvent extends ApplicationEvent {
	
	public AdminAuditEvent(Object source) {
		super(source);
	}
	
	//实例编号
	private String instanceId;
	
	//操作员
	private String operator;
	
	//访问者IP地址
	private String remoteAddr;
	
	//访问路径
	private String requestURI;
	
	//访问方法
	private String requestMethod;
	
	//访问参数
	private String requestParam;

	//处理开始时间
	private Date preHandleTime;
	
	//处理结束时间
	private Date postHandleTime;
	
	//处理描述，从`RequestMapping`注解的`name`属性中获取
	private String handlerDesc;
}
