package org.krproject.ocean.vitamins.admin.config;

import org.krproject.ocean.vitamins.admin.interceptor.AdminAuditInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;


/**
 * Admin WebMvc 配置.
 * 
 * @author Tiger
 */
@Configuration
public class AdminWebMvcConfig implements WebMvcConfigurer {

	@Autowired
	private AdminAuditInterceptor adminAuditInterceptor;
	
	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(this.adminAuditInterceptor).addPathPatterns("/**");
	}
}
