package org.krproject.ocean.vitamins.admin.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

import org.krproject.ocean.vitamins.admin.annotation.SecurityPriv;
import org.krproject.ocean.vitamins.admin.annotation.SecurityRole;
import org.krproject.ocean.vitamins.admin.constants.AdminConstants;
import org.krproject.ocean.vitamins.admin.service.AdminSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;


/**
 * Admin Web Security 配置.
 * 
 * @author Tiger
 */
@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true, securedEnabled = true)
public class AdminSecurityConfig extends WebSecurityConfigurerAdapter {

	@Resource
	private AdminProperties adminProperties;
	
	@Autowired
	@Qualifier(AdminConstants.USER_PASSWORD_ENCODER)
	private PasswordEncoder userPasswordEncoder;

	@Autowired
	private AdminSecurityService adminSecurityService;
	
	@Autowired
	private ConfigurableApplicationContext applicationContext;

	
	@Bean
	@Override
	public AuthenticationManager authenticationManagerBean() throws Exception {
		return super.authenticationManagerBean();
	}
	
	@Override
	protected void configure(AuthenticationManagerBuilder auth) throws Exception {
		auth.userDetailsService(this.adminSecurityService).passwordEncoder(this.userPasswordEncoder);
	}
	
	@Override
	public void configure(WebSecurity web) throws Exception {
		
		web.ignoring()
		// Permit swagger web resources
		.antMatchers("/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html")
		// Permit user specified web resources
		.antMatchers(this.adminProperties.getSecurityIgnoringPathes().toArray(new String[0]));
	}


	/**
	 * 初始化角色权限.
	 */
	@PostConstruct
	public void init() {
		if (this.adminProperties.getSecurityInitEnabled()) {
			Map<String, Object> roles = this.applicationContext.getBeansWithAnnotation(SecurityRole.class);
			for (Object obj : roles.values()) {
				SecurityRole role = ClassUtils.getUserClass(obj).getAnnotation(SecurityRole.class);
				if (role != null && StringUtils.hasLength(role.name())) {
					List<String> privNames = new ArrayList<String>();
					for (SecurityPriv priv : role.prives()) {
						privNames.add(priv.name());
						this.adminSecurityService.createPriv(priv.name(), priv.desc());
					}
					this.adminSecurityService.createRole(role.name(), role.desc(), privNames);
				}
			}
		}
	}
}
