package org.krproject.ocean.vitamins.admin.config;

import java.util.ArrayList;
import java.util.List;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;


/**
 * 属性配置.
 * 
 * @author Tiger
 */
@Data
@ConfigurationProperties(prefix = "krproject.ocean.admin")
public class AdminProperties {

	/**
	 * 是否启用后管参数管理，默认启用.
	 */
	private Boolean paramEnabled = true;

	/**
	 * Swagger是否启用（默认不启用）.
	 */
	private Boolean swaggerEnabled = false;

	/**
	 * 是否创建角色权限，默认不创建.
	 */
	private Boolean securityInitEnabled = false;

	/**
	 * 忽略安全控制的路径列表.
	 */
	private List<String> securityIgnoringPathes = new ArrayList<String>();  

}
