package org.krproject.ocean.vitamins.admin.config;

import javax.annotation.Resource;

import org.krproject.ocean.vitamins.admin.constants.AdminConstants;
import org.krproject.ocean.vitamins.admin.service.AdminSecurityService;
import org.krproject.ocean.vitamins.admin.service.impl.FakeAdminSecurityServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;



/**
 * Admin 配置.
 * 
 * @author Tiger
 */
@Configuration
@ComponentScan("org.krproject.ocean.vitamins.admin")
@EnableConfigurationProperties(AdminProperties.class)
public class AdminConfig {

	@Resource
	private AdminProperties adminProperties;
	
	// 解决权限以'ROLE_'前缀开头的问题
	@Bean
	public GrantedAuthorityDefaults grantedAuthorityDefaults() {
		return new GrantedAuthorityDefaults("");
	}

	@Bean(name = AdminConstants.USER_PASSWORD_ENCODER)
	@ConditionalOnMissingBean(name = AdminConstants.USER_PASSWORD_ENCODER)
	public PasswordEncoder adminUserPasswordEncoder() {
		return new BCryptPasswordEncoder();
	}
	
	@Bean(name = AdminConstants.CLIENT_PASSWORD_ENCODER)
	@ConditionalOnMissingBean(name = AdminConstants.CLIENT_PASSWORD_ENCODER)
	public PasswordEncoder adminClientPasswordEncoder() {
		return new BCryptPasswordEncoder();
	}
	
	@Bean(name = AdminConstants.SECURITY_SERVICE)
	@ConditionalOnMissingBean(name = AdminConstants.SECURITY_SERVICE)
	public AdminSecurityService adminSecurityServiceImpl() {
		return new FakeAdminSecurityServiceImpl();
	}
	
	@Bean
	@ConditionalOnMissingBean
	public MappingJackson2HttpMessageConverter adminMappingJackson2HttpMessageConverter() {
		ObjectMapper objectMapper = new ObjectMapper();
		objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		objectMapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, false);
		objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
		return new MappingJackson2HttpMessageConverter(objectMapper);
	}
}
