package org.krproject.ocean.vitamins.admin.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 安全角色注解.
 * 
 * @author Tiger
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface SecurityRole {

	/**
	 * 角色名称. 
	 * @return 角色名称
	 */
	String name() default "";

	/**
	 * 角色描述. 
	 * @return 角色描述
	 */
	String desc() default "";

	/**
	 * 权限列表. 
	 * @return 权限列表
	 */
	SecurityPriv[] prives() default {};
}
