package org.krproject.ocean.vitamins.admin.service;

import java.util.List;

import org.krproject.ocean.vitamins.admin.model.param.ParamAuditVo;
import org.krproject.ocean.vitamins.admin.model.param.ParamVo;
import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;


/**
 * 参数服务接口.
 * 
 * @author Tiger
 */
public interface AdminParamService {
	
	/**
	 * 获取一类参数.
	 * @param orgId orgId
	 * @param paramClassName paramClassName
	 * @return List
	 */
	List<ParamVo> getParameterList(String orgId, String paramClassName);
	
	/**
	 * 获取参数.
	 * @param orgId orgId
	 * @param paramClassName paramClassName
	 * @param key key
	 * @return Object object
	 */
	ParamVo getParameter(String orgId, String paramClassName, String key);
	
	/**
	 * 增加参数.
	 * @param paramVo paramVo
	 */
	void addParameter(ParamVo paramVo);
	
	/**
	 * 更新参数.
	 * @param paramVo paramVo
	 */
	void updateParameter(ParamVo paramVo);
	
	/**
	 * 删除参数.
	 * @param orgId orgId
	 * @param paramClassName paramClassName
	 * @param key key
	 * @param mtnUser mtnUser
	 */
	void removeParameter(String orgId, String paramClassName, String key, String mtnUser);
	
	/**
	 * 分页获取参数审计日志.
	 * @param orgId orgId
	 * @param paramClass paramClass
	 * @param paramKey paramKey
	 * @param paramOperation paramOperation
	 * @param pageable pageable
	 * @return 参数审计日志
	 */
	Page<ParamAuditVo> pageParamAudit(String orgId, String paramClass, String paramKey, ParamOperationEnum paramOperation, Pageable pageable);

}
