package org.krproject.ocean.vitamins.admin.model.param;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 参数信息.
 * 
 * @author Tiger
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
@ApiModel(description = "参数信息")
public class ParamVo implements Serializable {
	
	@ApiModelProperty(value = "分支编号", required = true)
	private String orgId;
	
	@ApiModelProperty(value = "参数类名", required = true)
	private String paramClassName;
	
	@ApiModelProperty(value = "参数键", required = true)
	private String paramKey;
	
	@ApiModelProperty(value = "参数值", required = true)
	private String paramObject;
	
	@ApiModelProperty(value = "维护人员", required = true)
	private String mtnUser;
}
