package org.krproject.ocean.vitamins.admin.model.param;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import org.krproject.ocean.vitamins.param.domain.enums.ParamOperationEnum;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 参数审计信息.
 * @author zhongyang
 *
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@SuppressWarnings("serial")
@ApiModel(description = "参数审计信息")
public class ParamAuditVo implements Serializable {
	
	@ApiModelProperty(value = "主键", required = true)
	private BigDecimal auditId;
	
	@ApiModelProperty(value = "机构号", required = true)
	private String orgId;
	
	@ApiModelProperty(value = "参数类名", required = true)
	private String paramClass;
	
	@ApiModelProperty(value = "参数键值", required = true)
	private String paramKey;
	
	@ApiModelProperty(value = "参数操作类型", required = true)
	private ParamOperationEnum paramOperation;
	
	@ApiModelProperty(value = "原参数", required = true)
	private String oldObject;
	
	@ApiModelProperty(value = "现参数", required = true)
	private String newObject;
	
	@ApiModelProperty(value = "维护用户", required = true)
	private String mtnUser;
	
	@ApiModelProperty(value = "维护备注", required = true)
	private String mtnMemo;
	
	@ApiModelProperty(value = "创建时间", required = true)
	private Date createTime;

}
