package org.krproject.ocean.vitamins.admin.model.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 当前登陆用户信息.
 * 
 * @author Tiger
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "当前登陆用户信息")
@SuppressWarnings("serial")
public class AppUserVo implements Serializable {
	
	@ApiModelProperty(value = "用户编号", required = true)
	private String id;
	
	@ApiModelProperty(value = "用户拥有的权限列表", required = true)
	private List<String> authorities = new ArrayList<String>();
	
}
