package org.krproject.ocean.vitamins.admin.model;

import org.springframework.http.HttpStatus;

/**
 * 响应代码.
 * 
 * @author Tiger
 */
public enum AdminRespCode {

	/**
	 * 处理成功.
	 */
	SUCCESS("0000", HttpStatus.OK),
	
	/**
	 * 处理失败.
	 */
	FAILURE("9999", HttpStatus.OK),
	
	/**
	 * 请求不合法.
	 */
	BAD_REQUEST("4000", HttpStatus.BAD_REQUEST),
	
	/**
	 * 请求未授权.
	 */
	UNAUTHORIZED("4010", HttpStatus.UNAUTHORIZED),

	/**
	 * 禁止访问.
	 */
	FORBIDDEN("4030", HttpStatus.FORBIDDEN),

	/**
	 * 业务失败：数据不存在.
	 */
	NOT_FOUND("4040", HttpStatus.OK),
	
	/**
	 * 业务失败：数据已存在.
	 */
	ALREADY_EXISTS("4090", HttpStatus.OK),
	
	/**
	 * 系统内部错误.
	 */
	SYSTEM_ERROR("5000", HttpStatus.INTERNAL_SERVER_ERROR);
	
	private String code;
	
	private HttpStatus httpStatus;
	
	AdminRespCode(String code, HttpStatus httpStatus) {
		this.setCode(code);
		this.setHttpStatus(httpStatus);
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	public HttpStatus getHttpStatus() {
		return this.httpStatus;
	}

	public void setHttpStatus(HttpStatus httpStatus) {
		this.httpStatus = httpStatus;
	}
	
}
