package org.krproject.ocean.vitamins.admin.controller.app;

import java.security.Principal;

import org.krproject.ocean.vitamins.admin.annotation.SecurityPriv;
import org.krproject.ocean.vitamins.admin.annotation.SecurityRole;
import org.krproject.ocean.vitamins.admin.model.AdminResponse;
import org.krproject.ocean.vitamins.admin.model.app.AppUserVo;
import org.krproject.ocean.vitamins.admin.service.AdminAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import springfox.documentation.annotations.ApiIgnore;

/**
 * 基础应用处理器.
 * 
 * @author Tiger
 */
@Slf4j
@Api(value = "/app", produces = MediaType.APPLICATION_JSON_VALUE)
@RequestMapping(value = "/app", produces = {MediaType.APPLICATION_JSON_VALUE})
@RestController
@SecurityRole(name = "ROLE_KR_APP", desc = "基础应用_角色", prives = {
		@SecurityPriv(name = "PRIV_KR_APP_READ", desc = "基础应用_读权限"), 
		@SecurityPriv(name = "PRIV_KR_APP_WRITE", desc = "基础应用_写权限")}
)
public class AdminAppController {
	
	@Autowired
	private AdminAppService adminAppService;
	
	@Secured("PRIV_KR_APP_READ")
	@RequestMapping(value = "/me", method = RequestMethod.GET, name = "获取登录用户信息")
	public ResponseEntity<AdminResponse> me(@ApiIgnore Principal principal) {
		log.debug("me is {}", principal.getName());
		
		AppUserVo user = this.adminAppService.getUser(principal.getName());
		
		return ResponseEntity.ok(new AdminResponse(user));
	}

}
