package org.krproject.ocean.vitamins.admin.config;

import org.krproject.ocean.vitamins.admin.constants.AdminConstants;
import org.krproject.ocean.vitamins.admin.service.AdminSecurityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;


/**
 * OAuth2授权服务配置.
 * 
 * @author Tiger
 */
@Configuration
@EnableAuthorizationServer
public class AdminOAuth2AuthorizationConfig extends AuthorizationServerConfigurerAdapter {

	@Autowired
	@Qualifier(AdminConstants.CLIENT_PASSWORD_ENCODER)
	private PasswordEncoder clientPasswordEncoder;

	@Autowired
	private AuthenticationManager authenticationManager;

	@Autowired
	private AdminSecurityService adminSecurityService;
	
	@Bean
	public TokenStore tokenStore() {
		return new JwtTokenStore(jwtAccessTokenConverter());
	}

	@Bean
	public JwtAccessTokenConverter jwtAccessTokenConverter() {
		return new JwtAccessTokenConverter();
	}

	
	@Override
	public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
		endpoints.authenticationManager(this.authenticationManager)
				.userDetailsService(this.adminSecurityService) //needed for refresh
				.accessTokenConverter(jwtAccessTokenConverter())
				.tokenStore(tokenStore());
	}
	
	@Override
	public void configure(AuthorizationServerSecurityConfigurer oauthServer) throws Exception {
		oauthServer.tokenKeyAccess("isAuthenticated()")
				.checkTokenAccess("isAuthenticated()")
				.passwordEncoder(this.clientPasswordEncoder);
	}
	
	@Override
	public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
		clients.withClientDetails(this.adminSecurityService);
	}
}
