package org.krproject.ocean.skeletons.octopus.param;

import java.io.Serializable;

import org.krproject.ocean.vitamins.param.document.Param;
import org.krproject.ocean.vitamins.param.document.ParamField;

import lombok.Data;


/**
 * 下游系统参数.
 * 
 * @author Tiger
 */
@Data
@Param(name = "下游系统参数", desc = "对于下游对接系统的定义与控制")
@SuppressWarnings("serial")
public class OutboundSystemParam implements Serializable {

	@ParamField(name = "系统代码", desc = "系统代码", key = true)
	private String code;
	
	@ParamField(name = "系统名称", desc = "系统名称")
	private String name;
	
	@ParamField(name = "系统描述", desc = "系统描述")
	private String desc;
	
	@ParamField(name = "是否启用挡板", desc = "是否启用挡板", defaultValue = "false")
	private Boolean mockEnabled = false;
	
	@ParamField(name = "挡板方案", desc = "挡板方案")
	private String mockScenario = "";
}
