/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.transaction;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.krproject.ocean.skeletons.octopus.online.transaction.AbstractInquirer;
import org.krproject.ocean.skeletons.octopus.online.transaction.event.InquireCompletedEvent;
import org.krproject.ocean.skeletons.octopus.online.transaction.model.OnlineOutboundModel;
import org.krproject.ocean.skeletons.octopus.online.transaction.service.OctopusOnlineTransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class InquireServiceActivator {
    private static final Logger log = LoggerFactory.getLogger(InquireServiceActivator.class);
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private OctopusOnlineTransactionService octopusOnlineTransactionService;
    @Autowired(required=false)
    private List<AbstractInquirer> inquirers;
    private Map<String, AbstractInquirer> inquirerMap = new ConcurrentHashMap<String, AbstractInquirer>();

    @PostConstruct
    public void init() {
        if (this.inquirers != null) {
            for (AbstractInquirer inquirer : this.inquirers) {
                AbstractInquirer inquirerFound = this.inquirerMap.get(inquirer.getProcessorName());
                if (inquirerFound != null) {
                    log.error("inquirer {} and {} got same processor name\uff1a{}", new Object[]{inquirerFound, inquirer, inquirer.getProcessorName()});
                    throw new RuntimeException("duplicate inquirer for processor " + inquirer.getProcessorName());
                }
                this.inquirerMap.put(inquirer.getProcessorName(), inquirer);
            }
        }
    }

    @ServiceActivator(inputChannel="octopusSkeletonOnlineInquireChannel")
    private void activate(String inboundId) throws Exception {
        log.info("inquire inboundId:{}", (Object)inboundId);
        Boolean succeed = true;
        for (OnlineOutboundModel outbound : this.octopusOnlineTransactionService.listOutboundForInquire(inboundId)) {
            log.debug("inquire outboundId:{} of inboundId:{}!", (Object)outbound.getOutboundId(), (Object)inboundId);
            AbstractInquirer inquirer = this.inquirerMap.get(outbound.getProcessorName());
            if (inquirer == null) continue;
            Boolean result = this.inquireOutbound(outbound.getOutboundId(), inquirer);
            if (result == null) {
                succeed = null;
                break;
            }
            if (result.booleanValue()) continue;
            succeed = false;
            break;
        }
        log.info("inquire inboundId:{} result:{}", (Object)inboundId, (Object)succeed);
        if (succeed != null) {
            if (succeed.booleanValue()) {
                this.octopusOnlineTransactionService.replay(inboundId);
            } else {
                this.octopusOnlineTransactionService.reverse(inboundId);
            }
        }
        this.applicationContext.publishEvent((ApplicationEvent)new InquireCompletedEvent(this, inboundId, succeed));
    }

    private Boolean inquireOutbound(String outboundId, AbstractInquirer inquirer) {
        Boolean result = null;
        for (int retry = 1; retry <= inquirer.getInquireTimes(); ++retry) {
            log.debug("inquire outboundId:{} with times:{}!", (Object)outboundId, (Object)retry);
            try {
                if (inquirer.inquire(outboundId).booleanValue()) {
                    log.debug("inquire outboundId:{} success!", (Object)outboundId);
                    result = true;
                    break;
                }
                log.debug("inquire outboundId:{} failure!", (Object)outboundId);
                result = false;
                break;
            }
            catch (Exception e) {
                log.debug("inquire outboundId:{} exception:{}!, retry later!", (Object)outboundId, (Object)e);
                try {
                    Thread.sleep(inquirer.getInquireInterval());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return result;
    }
}

