/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusInternalRequest;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusInternalResponse;
import org.krproject.ocean.skeletons.octopus.online.internal.AbstractInternalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.ClassUtils;

@MessageEndpoint
public class OctopusInternalActivator {
    private static final Logger log = LoggerFactory.getLogger(OctopusInternalActivator.class);
    @Resource
    private Validator validator;
    @Autowired(required=false)
    private List<AbstractInternalHandler<?, ?>> internalHandlers;
    private static boolean initialized = false;
    private static final Map<String, AbstractInternalHandler<?, ?>> INTERNAL_HANDLER_MAP = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.internalHandlers != null) {
                for (AbstractInternalHandler<?, ?> handler : this.internalHandlers) {
                    AbstractInternalHandler<?, ?> handlerFound = INTERNAL_HANDLER_MAP.get(handler.getRequestName());
                    if (handlerFound != null) {
                        log.error("internal handler {} and {} got same request name\uff1a{}", new Object[]{handlerFound, handler, handler.getRequestName()});
                        throw new RuntimeException("duplicate internal handler for request " + handler.getRequestName());
                    }
                    INTERNAL_HANDLER_MAP.put(handler.getRequestName(), handler);
                    log.debug("Loaded Internal Handler:{} for Request:{}", (Object)ClassUtils.getUserClass(handler).getName(), (Object)handler.getRequestName());
                }
            }
            initialized = true;
        }
    }

    @ServiceActivator(inputChannel="octopusSkeletonOnlineInternalChannel")
    public OctopusInternalResponse activate(OctopusInternalRequest<OctopusInternalResponse> request) {
        Object response = (OctopusInternalResponse)request.createResponse();
        Set constraintViolations = this.validator.validate(request, new Class[0]);
        Iterator iterator = constraintViolations.iterator();
        if (iterator.hasNext()) {
            ConstraintViolation cv = (ConstraintViolation)iterator.next();
            log.error("constraint voilations:{}, {}", (Object)cv.getPropertyPath(), (Object)cv.getMessage());
            return response;
        }
        String requestClassName = ClassUtils.getUserClass(request).getName();
        AbstractInternalHandler<?, ?> handler = INTERNAL_HANDLER_MAP.get(requestClassName);
        if (handler == null) {
            log.error("fail to get handler for request:{}", (Object)requestClassName);
            return response;
        }
        try {
            response = handler.handle(request);
        }
        catch (Exception e) {
            log.error("handle internal request:{} failed with exception", request, (Object)e);
            return response;
        }
        return response;
    }
}

