package org.krproject.ocean.skeletons.octopus.online.transaction;

/**
 * 质询抽象类.
 * 
 * @author Tiger
 */
public abstract class AbstractInquirer {

	/**
	 * 质询次数.
	 * @return 质询次数.
	 */
	public abstract Integer getInquireTimes();
	
	/**
	 * 质询间隔（毫秒）.
	 * @return 质询间隔（毫秒）.
	 */
	public abstract Long getInquireInterval();

	/**
	 * 获取对应处理器名.
	 * 
	 * @return 对应处理器名
	 */
	public abstract String getProcessorName();

	/**
	 * 对指定下游系统交易进行质询.
	 * 
	 * @param outboundId 下游系统交易编号
	 * 
	 * @return 原交易是否成功
	 */
	public abstract Boolean inquire(String outboundId);
}
