package org.krproject.ocean.skeletons.octopus.online.internal.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.PostConstruct;

import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListOutboundMockScenarioRequest;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListOutboundMockScenarioResponse;
import org.krproject.ocean.skeletons.octopus.online.api.internal.model.OutboundMockScenario;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusSkeletonOnlineException;
import org.krproject.ocean.skeletons.octopus.online.internal.AbstractInternalHandler;
import org.krproject.ocean.skeletons.octopus.online.outbound.OctopusOutboundMockScenario;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;


/**
 * 交易类交易处理.
 * 
 * @author Tiger
 */
@Slf4j
@Component
public class OctopusListOutboundMockScenarioHandler extends AbstractInternalHandler<OctopusListOutboundMockScenarioRequest, OctopusListOutboundMockScenarioResponse> {
	
	@Autowired(required = false)
	private List<OctopusOutboundMockScenario> mockScenarios;

	private Map<String, OctopusOutboundMockScenario> mockScenarioMap = new ConcurrentHashMap<String, OctopusOutboundMockScenario>();

	@PostConstruct
	public void init() {
		// 加载下游系统挡板场景
		if (this.mockScenarios != null) {
			for (OctopusOutboundMockScenario scenario : this.mockScenarios) {
				String scenarioKey = scenario.getSystemId() + "-" + scenario.getScenarioName();
				OctopusOutboundMockScenario scenarioFound = this.mockScenarioMap.get(scenarioKey);
				if (scenarioFound != null) {
					log.error("duplicate outbound mock scenario:{}, {}", scenarioFound, scenario);
					throw new RuntimeException("duplicate outbound mock scenario " + scenarioKey);
				}
				this.mockScenarioMap.put(scenarioKey, scenario);
				log.info("Found OutboundMockScenario:{}, {}", scenarioKey, scenario.getScenarioDesc());
			}
		}
	}

	
	@Override
	public OctopusListOutboundMockScenarioResponse handle(OctopusListOutboundMockScenarioRequest request) throws OctopusSkeletonOnlineException {
		log.debug("doHandle request:{}", request);
		
		// 构建默认响应
		OctopusListOutboundMockScenarioResponse response = request.createResponse();

		for (OctopusOutboundMockScenario scenario: this.mockScenarioMap.values()) {
			if (scenario.getSystemId().equals(request.getSystemId())) {
				OutboundMockScenario s = new OutboundMockScenario();
				s.setSystemId(scenario.getSystemId());
				s.setScenarioName(scenario.getScenarioName());
				s.setScenarioDesc(scenario.getScenarioDesc());
				response.getOutboundMockScenarioList().add(s);
			}
		}
		
		return response;
	}

}
