package org.krproject.ocean.skeletons.octopus.online.event;

import java.util.Date;

import org.krproject.ocean.skeletons.octopus.online.outbound.AbstractProcessor;
import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 下游系统交易处理完成事件.
 * @author Tiger
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class ProcessCompletedEvent extends ApplicationEvent {
	
	public ProcessCompletedEvent(Object source, 
			Object request, 
			Date requestTime,
			AbstractProcessor<?, ?> processor, 
			Object response,
			Date responseTime) {
		super(source);
		this.request = request;
		this.requestTime = requestTime;
		this.processor = processor;
		this.response = response;
		this.responseTime = responseTime;
	}
	
	// 下游系统交易请求
	private Object request;	

	// 下游系统交易请求时间
	private Date requestTime;

	// 下游系统交易处理器
	private AbstractProcessor<?, ?> processor;
	
	// 下游系统交易响应
	private Object response;
	
	// 下游系统交易响应时间
	private Date responseTime;

}
