package org.krproject.ocean.skeletons.octopus.online.context;

import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineRequest;
import org.krproject.ocean.skeletons.octopus.online.inbound.AbstractHandler;
import org.krproject.ocean.skeletons.octopus.online.outbound.AbstractProcessor;

import lombok.Data;


/**
 * Octopus联机交易上下文.
 * 
 * @author Tiger
 */
@Data
public class OctopusOnlineContext {
	
	/**
	 * 上游渠道交易请求.
	 */
	private OctopusSkeletonOnlineRequest<?> inboundRequest;	
	
	/**
	 * 上游渠道交易处理器.
	 */
	private AbstractHandler<?, ?> inboundHandler;
	
	/**
	 * 上游渠道流水实体，不记录流水时为空.
	 */
	public Object inboundEntity;
	
	/**
	 * 下游系统交易请求.
	 */
	private Object outboundRequest;
	
	/**
	 * 下游系统交易处理器.
	 */
	private AbstractProcessor<?, ?> outboundProcessor;
	
	/**
	 * 下游系统流水实体，不记录流水时为空.
	 */
	private Object outboundEntity;
	
	/**
	 * 扩展对象，用户自定义.
	 */
	private Object extendObject;
}
