/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.transaction;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.krproject.ocean.skeletons.octopus.online.transaction.AbstractReverser;
import org.krproject.ocean.skeletons.octopus.online.transaction.event.ReverseCompletedEvent;
import org.krproject.ocean.skeletons.octopus.online.transaction.model.OnlineOutboundModel;
import org.krproject.ocean.skeletons.octopus.online.transaction.service.OctopusOnlineTransactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;

@MessageEndpoint
public class ReverseServiceActivator {
    private static final Logger log = LoggerFactory.getLogger(ReverseServiceActivator.class);
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private OctopusOnlineTransactionService octopusOnlineJournalService;
    @Autowired(required=false)
    private List<AbstractReverser> reversers;
    private Map<String, AbstractReverser> reverserMap = new ConcurrentHashMap<String, AbstractReverser>();

    @PostConstruct
    public void init() {
        if (this.reversers != null) {
            for (AbstractReverser reverser : this.reversers) {
                AbstractReverser reverserFound = this.reverserMap.get(reverser.getProcessorName());
                if (reverserFound != null) {
                    log.error("reverser {} and {} got same processor name\uff1a{}", new Object[]{reverserFound, reverser, reverser.getProcessorName()});
                    throw new RuntimeException("duplicate reverser for processor " + reverser.getProcessorName());
                }
                this.reverserMap.put(reverser.getProcessorName(), reverser);
            }
        }
    }

    @ServiceActivator(inputChannel="octopusSkeletonOnlineReverseChannel")
    private void activate(String inboundId) throws Exception {
        log.info("reverse inboundId:{} ", (Object)inboundId);
        Boolean reversed = true;
        for (OnlineOutboundModel outbound : this.octopusOnlineJournalService.listOutboundForReverse(inboundId)) {
            log.debug("reverse outboundId:{} of inboundId:{}!", (Object)outbound.getOutboundId(), (Object)inboundId);
            AbstractReverser reverser = this.reverserMap.get(outbound.getProcessorName());
            if (reverser == null) continue;
            Boolean result = this.reverseOutbound(outbound.getOutboundId(), reverser);
            if (result == null) {
                reversed = null;
                break;
            }
            if (result.booleanValue()) continue;
            reversed = false;
            break;
        }
        log.info("reverse inboundId:{} result:{}", (Object)inboundId, (Object)reversed);
        this.applicationContext.publishEvent((ApplicationEvent)new ReverseCompletedEvent(this, inboundId, reversed));
    }

    private Boolean reverseOutbound(String outboundId, AbstractReverser reverser) {
        Boolean result = null;
        for (int retry = 1; retry <= reverser.getReverseTimes(); ++retry) {
            log.debug("reverse outboundId:{} with times:{}!", (Object)outboundId, (Object)retry);
            try {
                if (reverser.reverse(outboundId).booleanValue()) {
                    log.debug("reverse outboundId:{} success!", (Object)outboundId);
                    result = true;
                    break;
                }
                log.debug("reverse outboundId:{} failure!", (Object)outboundId);
                result = false;
                break;
            }
            catch (Exception e) {
                log.debug("reverse outboundId:{} exception:{}!, retry later!", (Object)outboundId, (Object)e);
                try {
                    Thread.sleep(reverser.getReverseInterval());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return result;
    }
}

