/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.outbound;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.krproject.ocean.skeletons.octopus.online.context.OctopusOnlineContextHolder;
import org.krproject.ocean.skeletons.octopus.online.event.ProcessCompletedEvent;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusDuplicatedOutboundException;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusSkeletonOnlineException;
import org.krproject.ocean.skeletons.octopus.online.outbound.AbstractProcessor;
import org.krproject.ocean.skeletons.octopus.param.OutboundSystemParam;
import org.krproject.ocean.vitamins.param.service.ParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractOutboundDispatcher<REQ, RESP> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOutboundDispatcher.class);
    @Resource
    private ParamService paramService;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<AbstractProcessor<?, ?>> processors;
    private static boolean initialized = false;
    private static final Map<String, AbstractProcessor<?, ?>> PROCESSOR_MAP = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.processors != null) {
                for (AbstractProcessor<?, ?> processor : this.processors) {
                    AbstractProcessor<?, ?> processorFound = PROCESSOR_MAP.get(processor.getRequestName());
                    if (processorFound != null) {
                        log.error("processors {} and {} got same request name\uff1a{}", new Object[]{processorFound, processor, processor.getRequestName()});
                        throw new RuntimeException("Duplicate processors for request " + processor.getRequestName());
                    }
                    PROCESSOR_MAP.put(processor.getRequestName(), processor);
                    log.debug("Loaded Processor:{} for Request:{}", (Object)ClassUtils.getUserClass(processor).getName(), (Object)processor.getRequestName());
                }
            }
            initialized = true;
        }
    }

    public abstract RESP responseWithException(REQ var1, Exception var2);

    public abstract Object insertOutbound(String var1, String var2, REQ var3);

    public abstract void updateOutbound(Object var1, AbstractProcessor<REQ, RESP> var2, RESP var3);

    protected RESP doDispatch(String systemId, String systemTxnId, REQ request) throws OctopusDuplicatedOutboundException {
        if (!StringUtils.hasLength((String)systemId)) {
            log.error("systemId cant't be empty");
            throw new OctopusSkeletonOnlineException("systemId cant't be empty");
        }
        if (!StringUtils.hasLength((String)systemTxnId)) {
            log.error("systemTxnId cant't be empty");
            throw new OctopusSkeletonOnlineException("systemTxnId cant't be empty");
        }
        if (request == null) {
            log.error("request cant't be null");
            throw new OctopusSkeletonOnlineException("request cant't be null");
        }
        long requestTime = System.currentTimeMillis();
        Object outbound = null;
        try {
            outbound = this.insertOutbound(systemId, systemTxnId, request);
        }
        catch (Exception e) {
            throw new OctopusDuplicatedOutboundException("duplicated trans, systemId:" + systemId + " systemTxnId:" + systemTxnId, e);
        }
        RESP response = null;
        AbstractProcessor<?, ?> processor = null;
        try {
            OutboundSystemParam outboundSystem = (OutboundSystemParam)this.paramService.getParameter(OutboundSystemParam.class, systemId);
            if (outboundSystem == null) {
                log.error("unsupported system:{}", (Object)systemId);
                throw new OctopusSkeletonOnlineException("unsupported system: " + systemId);
            }
            log.debug("found parameter for outboundSystem :{}", (Object)outboundSystem);
            String requestClassName = ClassUtils.getUserClass(request).getName();
            if (outboundSystem.getMockEnabled().booleanValue()) {
                processor = PROCESSOR_MAP.get(requestClassName + outboundSystem.getMockScenario());
                if (processor == null) {
                    log.debug("no mock scenario:{} processor for request:{}, use default!", (Object)outboundSystem.getMockScenario(), (Object)requestClassName);
                    processor = PROCESSOR_MAP.get(requestClassName);
                    if (processor == null) {
                        log.error("no default processor for request {}", (Object)requestClassName);
                        throw new OctopusSkeletonOnlineException("no default processor for request " + requestClassName);
                    }
                }
            } else {
                processor = PROCESSOR_MAP.get(requestClassName);
                if (processor == null) {
                    log.error("no processor for request {}", (Object)requestClassName);
                    throw new OctopusSkeletonOnlineException("no processor for request " + requestClassName);
                }
            }
            log.debug("found processor:{} for request:{}", processor, request);
            OctopusOnlineContextHolder.getContext().setOutboundRequest(request);
            OctopusOnlineContextHolder.getContext().setOutboundEntity(outbound);
            OctopusOnlineContextHolder.getContext().setOutboundProcessor(processor);
            response = (RESP)processor.process(request);
        }
        catch (Exception exception) {
            response = this.responseWithException(request, exception);
        }
        this.updateOutbound(outbound, processor, response);
        long responseTime = System.currentTimeMillis();
        this.applicationContext.publishEvent((ApplicationEvent)new ProcessCompletedEvent(this, request, new Date(requestTime), processor, response, new Date(responseTime)));
        return response;
    }
}

