/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.online.internal.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListInboundFallbackScenarioRequest;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListInboundFallbackScenarioResponse;
import org.krproject.ocean.skeletons.octopus.online.api.internal.model.InboundFallbackScenario;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusSkeletonOnlineException;
import org.krproject.ocean.skeletons.octopus.online.inbound.OctopusInboundFallbackScenario;
import org.krproject.ocean.skeletons.octopus.online.internal.AbstractInternalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OctopusListInboundFallbackScenarioHandler
extends AbstractInternalHandler<OctopusListInboundFallbackScenarioRequest, OctopusListInboundFallbackScenarioResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusListInboundFallbackScenarioHandler.class);
    @Autowired(required=false)
    private List<OctopusInboundFallbackScenario> fallbackScenarios;
    private Map<String, OctopusInboundFallbackScenario> fallbackScenarioMap = new ConcurrentHashMap<String, OctopusInboundFallbackScenario>();

    @PostConstruct
    public void init() {
        if (this.fallbackScenarios != null) {
            for (OctopusInboundFallbackScenario scenario : this.fallbackScenarios) {
                String scenarioKey = scenario.getScenarioName();
                OctopusInboundFallbackScenario scenarioFound = this.fallbackScenarioMap.get(scenarioKey);
                if (scenarioFound != null) {
                    log.error("duplicate inbound fallback scenario:{}, {}", (Object)scenarioFound, (Object)scenario);
                    throw new RuntimeException("duplicate inbound fallback scenario " + scenarioKey);
                }
                this.fallbackScenarioMap.put(scenarioKey, scenario);
                log.info("Found InboundFallbackScenario:{}, {}", (Object)scenarioKey, (Object)scenario.getScenarioDesc());
            }
        }
    }

    @Override
    public OctopusListInboundFallbackScenarioResponse handle(OctopusListInboundFallbackScenarioRequest request) throws OctopusSkeletonOnlineException {
        log.debug("doHandle request:{}", (Object)request);
        OctopusListInboundFallbackScenarioResponse response = (OctopusListInboundFallbackScenarioResponse)request.createResponse();
        for (OctopusInboundFallbackScenario scenario : this.fallbackScenarioMap.values()) {
            InboundFallbackScenario s = new InboundFallbackScenario();
            s.setScenarioName(scenario.getScenarioName());
            s.setScenarioDesc(scenario.getScenarioDesc());
            response.getInboundFallbackScenarioList().add(s);
        }
        return response;
    }
}

