package org.krproject.ocean.skeletons.octopus.online.transaction.event;

import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;


/**
 * 冲正交易处理完成事件.
 * @author Tiger
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class ReverseCompletedEvent extends ApplicationEvent {
	
	public ReverseCompletedEvent(Object source, String inboundId, Boolean reversed) {
		super(source);
		this.inboundId = inboundId;
		this.reversed = reversed;
	}
	
	// 上游渠道流水表标识
	private String inboundId;

	// 本交易是否冲正成功，null-冲正异常，true-冲正成功，false-冲正失败
	private Boolean reversed; 

}
