package org.krproject.ocean.skeletons.octopus.online.transaction.event;

import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 质询交易处理完成事件.
 * @author Tiger
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class InquireCompletedEvent extends ApplicationEvent {
	
	public InquireCompletedEvent(Object source, String inboundId, Boolean succeed) {
		super(source);
		this.inboundId = inboundId;
		this.succeed = succeed;
	}
	
	// 上游渠道流水表标识
	private String inboundId;

	// 本交易是否成功，null-交易未明，true-交易成功，false-交易失败
	private Boolean succeed; 
	
}
