package org.krproject.ocean.skeletons.octopus.online.internal.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.PostConstruct;

import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListInboundFallbackScenarioRequest;
import org.krproject.ocean.skeletons.octopus.online.api.internal.OctopusListInboundFallbackScenarioResponse;
import org.krproject.ocean.skeletons.octopus.online.api.internal.model.InboundFallbackScenario;
import org.krproject.ocean.skeletons.octopus.online.exception.OctopusSkeletonOnlineException;
import org.krproject.ocean.skeletons.octopus.online.inbound.OctopusInboundFallbackScenario;
import org.krproject.ocean.skeletons.octopus.online.internal.AbstractInternalHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;


/**
 * 交易类交易处理.
 * 
 * @author Tiger
 */
@Slf4j
@Component
public class OctopusListInboundFallbackScenarioHandler extends AbstractInternalHandler<OctopusListInboundFallbackScenarioRequest, OctopusListInboundFallbackScenarioResponse> {
	
	@Autowired(required = false)
	private List<OctopusInboundFallbackScenario> fallbackScenarios;

	private Map<String, OctopusInboundFallbackScenario> fallbackScenarioMap = new ConcurrentHashMap<String, OctopusInboundFallbackScenario>();

	@PostConstruct
	public void init() {
		// 加载上游渠道降级场景
		if (this.fallbackScenarios != null) {
			for (OctopusInboundFallbackScenario scenario : this.fallbackScenarios) {
				String scenarioKey = scenario.getScenarioName();
				OctopusInboundFallbackScenario scenarioFound = this.fallbackScenarioMap.get(scenarioKey);
				if (scenarioFound != null) {
					log.error("duplicate inbound fallback scenario:{}, {}", scenarioFound, scenario);
					throw new RuntimeException("duplicate inbound fallback scenario " + scenarioKey);
				}
				this.fallbackScenarioMap.put(scenarioKey, scenario);
				log.info("Found InboundFallbackScenario:{}, {}", scenarioKey, scenario.getScenarioDesc());
			}
		}
	}
	
	@Override
	public OctopusListInboundFallbackScenarioResponse handle(OctopusListInboundFallbackScenarioRequest request) throws OctopusSkeletonOnlineException {
		log.debug("doHandle request:{}", request);
		
		// 构建默认响应
		OctopusListInboundFallbackScenarioResponse response = request.createResponse();
		
		for (OctopusInboundFallbackScenario scenario: this.fallbackScenarioMap.values()) {
			InboundFallbackScenario s = new InboundFallbackScenario();
			s.setScenarioName(scenario.getScenarioName());
			s.setScenarioDesc(scenario.getScenarioDesc());
			response.getInboundFallbackScenarioList().add(s);
		}
		
		return response;
	}

}
