package org.krproject.ocean.skeletons.octopus.online.inbound;

import java.lang.reflect.ParameterizedType;

import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineRequest;
import org.krproject.ocean.skeletons.octopus.online.api.OctopusSkeletonOnlineResponse;


/**
 * 上游渠道处理器抽象类.
 * 
 * @param <REQ> 请求泛型
 * @param <RESP> 响应泛型
 * @author Tiger
 */
public abstract class AbstractHandler<REQ extends OctopusSkeletonOnlineRequest<RESP>, RESP extends OctopusSkeletonOnlineResponse> {
	
	/**
	 * 获取请求处理名，用于对请求-处理器的匹配处理.
	 * 
	 * 默认为请求类名，降级场景下应通过重写本方法实现降级处理
	 * 
	 * @return 请求名
	 */
	@SuppressWarnings("unchecked")
	public String getRequestName() {
		Class<REQ> tClass = (Class<REQ>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass.getName();
	}
	
	/**
	 * 获取请求类.
	 * 
	 * @return 请求类
	 */
	@SuppressWarnings("unchecked")
	public Class<REQ> getRequestClass() {
		Class<REQ> tClass = (Class<REQ>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[0];
		return tClass;
	}
	
	/**
	 * 获取响应类.
	 * 
	 * @return 响应类
	 */
	@SuppressWarnings("unchecked")
	public Class<RESP> getResponseClass() {
		Class<RESP> tClass = (Class<RESP>) ((ParameterizedType) getClass().getGenericSuperclass())
				.getActualTypeArguments()[1];
		return tClass;
	}
	
	/**
	 * 上游渠道交易处理.
	 * 
	 * @param request 请求
	 * @return response 响应
	 * @throws Exception 联机统一异常
	 */
	public abstract RESP handle(REQ request) throws Exception;

}
