/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecutions;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInfo;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstance;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstances;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobParameter;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobParameters;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchStepExecution;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.skeletons.octopus.batch.systems.AbstractBatchClient;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobExecution;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobExecutions;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInfo;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInstance;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobInstances;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobParameter;
import org.krproject.ocean.vitamins.batch.service.model.BatchJobParameters;
import org.krproject.ocean.vitamins.batch.service.model.BatchStepExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OctopusBatchServiceImpl
implements OctopusBatchService {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchServiceImpl.class);
    @Autowired(required=false)
    private List<AbstractBatchClient> batchClients;
    private static boolean initialized = false;
    private static final Map<String, AbstractBatchClient> BATCH_CLIENT_MAP = new ConcurrentHashMap<String, AbstractBatchClient>();

    @PostConstruct
    public void init() {
        if (!initialized) {
            if (this.batchClients != null) {
                for (AbstractBatchClient batchClient : this.batchClients) {
                    AbstractBatchClient batchClientFound = BATCH_CLIENT_MAP.get(batchClient.getSystemId());
                    if (batchClientFound != null) {
                        log.error("batch client {} and {} got same systemId:{}", new Object[]{batchClientFound, batchClient, batchClient.getSystemId()});
                        throw new RuntimeException("Duplicate batch client:" + batchClient.getSystemId());
                    }
                    BATCH_CLIENT_MAP.put(batchClient.getSystemId(), batchClient);
                    log.debug("Loaded Batch Client for systemId:{}", (Object)batchClient.getSystemId());
                }
            }
            initialized = true;
        }
    }

    @Override
    public Set<String> getSystemIds() {
        return BATCH_CLIENT_MAP.keySet();
    }

    @Override
    public List<OctopusBatchJobInfo> getJobInfos() {
        ArrayList<OctopusBatchJobInfo> batchJobInfos = new ArrayList<OctopusBatchJobInfo>();
        HashMap<String, OctopusBatchJobInfo> jobsMap = new HashMap<String, OctopusBatchJobInfo>();
        for (AbstractBatchClient batchClient : BATCH_CLIENT_MAP.values()) {
            List<BatchJobInfo> remotebatchJobInfos = batchClient.getJobInfos();
            if (remotebatchJobInfos == null || remotebatchJobInfos.isEmpty()) continue;
            for (BatchJobInfo batchJobInfo : remotebatchJobInfos) {
                String key = batchJobInfo.getJobName();
                OctopusBatchJobInfo octopusBatchJobInfo = this.batchJobInfoConvert(batchClient.getSystemId(), batchJobInfo);
                jobsMap.put(key, octopusBatchJobInfo);
            }
        }
        for (OctopusBatchJobInfo batchJobInfo : jobsMap.values()) {
            batchJobInfos.add(batchJobInfo);
        }
        return batchJobInfos;
    }

    @Override
    public Long start(String operator, String systemId, String jobName, String parameters, Boolean chkLastJob) {
        log.debug("start, operator:{}, systemId:{}, jobName:{}, parameters:{}, chkLastJob:{}", new Object[]{operator, systemId, jobName, parameters, chkLastJob});
        if (!StringUtils.hasLength((String)jobName)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u4f5c\u4e1a\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        return batchClient.start(operator, jobName, parameters, chkLastJob);
    }

    @Override
    public Long restart(String operator, String systemId, long executionId) {
        log.debug("restart, operator:{}, systemId:{}, executionId:{}", new Object[]{operator, systemId, executionId});
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        return batchClient.restart(operator, executionId);
    }

    @Override
    public Long restartByJobName(String operator, String systemId, String jobName) {
        log.debug("restartByJobName, operator:{}, systemId:{}, jobName:{}", new Object[]{operator, systemId, jobName});
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        Long jobExecutionId = batchClient.restartByJobName(operator, jobName);
        return jobExecutionId;
    }

    @Override
    public boolean stop(String operator, String systemId, long executionId) {
        log.debug("stop, operator:{}, systemId:{}, executionId:{}", new Object[]{operator, systemId, executionId});
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        Boolean status = batchClient.stop(operator, executionId);
        return status;
    }

    @Override
    public OctopusBatchJobExecution abandon(String operator, String systemId, long jobExecutionId) {
        log.debug("abandon, operator:{}, systemId:{}, jobExecutionId:{}", new Object[]{operator, systemId, jobExecutionId});
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        OctopusBatchJobExecution batchJobExecution = this.jobExecutionConvert(batchClient.abandon(operator, jobExecutionId), true);
        return batchJobExecution;
    }

    @Override
    public Long startNextInstance(String operator, String systemId, String jobName, Boolean chkLastJob) {
        log.debug("startNextInstance, operator:{}, systemId:{}, jobName:{}, chkLastJob:{}", new Object[]{operator, systemId, jobName, chkLastJob});
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        Long jobExecutionId = batchClient.startNextInstance(operator, jobName, chkLastJob);
        return jobExecutionId;
    }

    @Override
    public OctopusBatchJobInstances getJobInstances(String systemId, String jobName, int start, int count) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        BatchJobInstances batchJobInstances = batchClient.getJobInstances(jobName, start, count);
        OctopusBatchJobInstances octopusBatchJobInstances = new OctopusBatchJobInstances();
        octopusBatchJobInstances.setJobInstancesSize(batchJobInstances.getJobInstancesSize());
        octopusBatchJobInstances.setJobInstances(this.jobInstancesConvert(batchJobInstances.getJobInstances()));
        return octopusBatchJobInstances;
    }

    @Override
    public OctopusBatchJobExecution getJobExecution(String systemId, Long executionId) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        OctopusBatchJobExecution batchJobExecution = this.jobExecutionConvert(batchClient.getJobExecution(executionId), true);
        return batchJobExecution;
    }

    @Override
    public OctopusBatchStepExecution getStepExecution(String systemId, Long jobExecutionId, Long stepExecutionId) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        OctopusBatchStepExecution batchStepExecution = this.stepExecutionConvert(batchClient.getStepExecution(jobExecutionId, stepExecutionId));
        return batchStepExecution;
    }

    @Override
    public OctopusBatchJobInstance getJobInstance(String systemId, Long instanceId) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        OctopusBatchJobInstance batchJobInstance = this.jobInstanceConvert(batchClient.getJobInstance(instanceId));
        return batchJobInstance;
    }

    @Override
    public List<OctopusBatchJobExecution> getJobExecutions(String systemId, Long instanceId) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        List<OctopusBatchJobExecution> batchJobExecutions = this.jobExecutionsConvert(batchClient.getJobExecutions(instanceId), false);
        return batchJobExecutions;
    }

    @Override
    public OctopusBatchJobExecutions getJobExecutionsByJobName(String systemId, String jobName, int jobStart, int jobCount) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        BatchJobExecutions batchJobExecutions = batchClient.getJobExecutionsByJobName(jobName, jobStart, jobCount);
        OctopusBatchJobExecutions octopusBatchJobExecutions = new OctopusBatchJobExecutions();
        octopusBatchJobExecutions.setJobTotalSize(batchJobExecutions.getJobTotalSize());
        octopusBatchJobExecutions.setJobExecutions(this.jobExecutionsConvert(batchJobExecutions.getJobExecutions(), false));
        return octopusBatchJobExecutions;
    }

    @Override
    public Set<OctopusBatchJobExecution> findRunningJobExecutions(String systemId, String jobName) {
        if (!BATCH_CLIENT_MAP.containsKey(systemId)) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "\u65e0\u6548systemId:" + systemId);
        }
        AbstractBatchClient batchClient = BATCH_CLIENT_MAP.get(systemId);
        Set<OctopusBatchJobExecution> batchJobExecutions = this.jobExecutionsConvert(batchClient.findRunningJobExecutions(jobName), false);
        return batchJobExecutions;
    }

    private OctopusBatchJobInfo batchJobInfoConvert(String systemId, BatchJobInfo batchJobInfo) {
        OctopusBatchJobInfo octopusBatchJobInfo = null;
        if (batchJobInfo != null) {
            octopusBatchJobInfo = new OctopusBatchJobInfo();
            octopusBatchJobInfo.setSystemId(systemId);
            octopusBatchJobInfo.setJobName(batchJobInfo.getJobName());
            octopusBatchJobInfo.setJobDescrition(batchJobInfo.getJobDescrition());
        }
        return octopusBatchJobInfo;
    }

    private List<OctopusBatchJobExecution> jobExecutionsConvert(List<BatchJobExecution> jobExecutions, boolean containStepInfo) {
        ArrayList<OctopusBatchJobExecution> jobExecutionsModel = new ArrayList<OctopusBatchJobExecution>();
        if (jobExecutions != null && jobExecutions.size() > 0) {
            for (BatchJobExecution jobExecution : jobExecutions) {
                jobExecutionsModel.add(this.jobExecutionConvert(jobExecution, containStepInfo));
            }
        }
        return jobExecutionsModel;
    }

    private Set<OctopusBatchJobExecution> jobExecutionsConvert(Set<BatchJobExecution> jobExecutions, boolean containStepInfo) {
        CopyOnWriteArraySet<OctopusBatchJobExecution> jobExecutionsModel = new CopyOnWriteArraySet<OctopusBatchJobExecution>();
        if (jobExecutions != null && jobExecutions.size() > 0) {
            for (BatchJobExecution jobExecution : jobExecutions) {
                jobExecutionsModel.add(this.jobExecutionConvert(jobExecution, containStepInfo));
            }
        }
        return jobExecutionsModel;
    }

    private OctopusBatchJobExecution jobExecutionConvert(BatchJobExecution jobExecution, boolean containStepInfo) {
        OctopusBatchJobExecution jobExecutionModel = null;
        if (jobExecution != null) {
            jobExecutionModel = new OctopusBatchJobExecution();
            jobExecutionModel.setId(jobExecution.getId());
            jobExecutionModel.setJobParameters(this.jobParametersConvert(jobExecution.getJobParameters()));
            jobExecutionModel.setJobInstance(this.jobInstanceConvert(jobExecution.getJobInstance()));
            if (containStepInfo) {
                jobExecutionModel.setStepExecutions(this.stepExecutionsConvert(jobExecution.getStepExecutions()));
            }
            if (jobExecution.getStatus() != null) {
                jobExecutionModel.setStatus(jobExecution.getStatus());
            }
            jobExecutionModel.setStartTime(jobExecution.getStartTime());
            jobExecutionModel.setCreateTime(jobExecution.getCreateTime());
            jobExecutionModel.setEndTime(jobExecution.getEndTime());
            jobExecutionModel.setLastUpdated(jobExecution.getLastUpdated());
            if (jobExecution.getExitStatus() != null) {
                jobExecutionModel.setExitStatus(jobExecution.getExitStatus());
            }
            jobExecutionModel.setJobConfigurationName(jobExecution.getJobConfigurationName());
        }
        return jobExecutionModel;
    }

    private List<OctopusBatchJobInstance> jobInstancesConvert(List<BatchJobInstance> jobInstances) {
        ArrayList<OctopusBatchJobInstance> jobInstancesModel = new ArrayList<OctopusBatchJobInstance>();
        if (jobInstances != null && jobInstances.size() > 0) {
            for (BatchJobInstance jobInstance : jobInstances) {
                jobInstancesModel.add(this.jobInstanceConvert(jobInstance));
            }
        }
        return jobInstancesModel;
    }

    private OctopusBatchJobInstance jobInstanceConvert(BatchJobInstance jobInstance) {
        OctopusBatchJobInstance jobInstanceModel = null;
        if (jobInstance != null) {
            jobInstanceModel = new OctopusBatchJobInstance();
            jobInstanceModel.setId(jobInstance.getId());
            jobInstanceModel.setInstanceId(jobInstance.getInstanceId());
            jobInstanceModel.setJobName(jobInstance.getJobName());
        }
        return jobInstanceModel;
    }

    private OctopusBatchJobParameters jobParametersConvert(BatchJobParameters jobParameters) {
        OctopusBatchJobParameters jobParametersModel = null;
        if (jobParameters != null) {
            jobParametersModel = new OctopusBatchJobParameters();
            Map paramMap = jobParameters.getParameters();
            if (!paramMap.isEmpty()) {
                HashMap paramMapModel = new HashMap();
                for (Map.Entry enSet : paramMap.entrySet()) {
                    paramMapModel.put(enSet.getKey(), this.jobParameterConvert((BatchJobParameter)enSet.getValue()));
                }
                jobParametersModel.setParameters(paramMapModel);
            }
        }
        return jobParametersModel;
    }

    private OctopusBatchJobParameter jobParameterConvert(BatchJobParameter jobParameter) {
        OctopusBatchJobParameter jobParameterModel = null;
        if (jobParameter != null) {
            jobParameterModel = new OctopusBatchJobParameter();
            jobParameterModel.setParameter(jobParameter.getParameter());
            jobParameterModel.setParameterType(jobParameter.getParameterType());
        }
        return jobParameterModel;
    }

    private Collection<OctopusBatchStepExecution> stepExecutionsConvert(Collection<BatchStepExecution> stepExecutions) {
        CopyOnWriteArraySet<OctopusBatchStepExecution> stepExecutionsModel = new CopyOnWriteArraySet<OctopusBatchStepExecution>();
        if (stepExecutions != null && stepExecutions.size() > 0) {
            for (BatchStepExecution stepExecution : stepExecutions) {
                stepExecutionsModel.add(this.stepExecutionConvert(stepExecution));
            }
        }
        return stepExecutionsModel;
    }

    private OctopusBatchStepExecution stepExecutionConvert(BatchStepExecution stepExecution) {
        OctopusBatchStepExecution stepExecutionModel = null;
        if (stepExecution != null) {
            stepExecutionModel = new OctopusBatchStepExecution();
            stepExecutionModel.setId(stepExecution.getId());
            stepExecutionModel.setJobExecutionId(stepExecution.getJobExecutionId());
            stepExecutionModel.setStepName(stepExecution.getStepName());
            if (stepExecution.getStatus() != null) {
                stepExecutionModel.setStatus(stepExecution.getStatus());
            }
            stepExecutionModel.setReadCount(stepExecution.getReadCount());
            stepExecutionModel.setWriteCount(stepExecution.getWriteCount());
            stepExecutionModel.setCommitCount(stepExecution.getCommitCount());
            stepExecutionModel.setRollbackCount(stepExecution.getRollbackCount());
            stepExecutionModel.setReadSkipCount(stepExecution.getReadSkipCount());
            stepExecutionModel.setProcessSkipCount(stepExecution.getProcessSkipCount());
            stepExecutionModel.setWriteSkipCount(stepExecution.getWriteSkipCount());
            stepExecutionModel.setStartTime(stepExecution.getStartTime());
            stepExecutionModel.setEndTime(stepExecution.getLastUpdated());
            stepExecutionModel.setLastUpdated(stepExecution.getLastUpdated());
            if (stepExecution.getExitStatus() != null) {
                stepExecutionModel.setExitStatus(stepExecution.getExitStatus());
                stepExecutionModel.setExitDescription(stepExecution.getExitDescription());
            }
            stepExecutionModel.setFilterCount(stepExecution.getFilterCount());
        }
        return stepExecutionModel;
    }
}

