/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OctopusBatchRestartHandler
extends AbstractOctopusBatchHandler<OctopusBatchRestartRequest, OctopusBatchRestartResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchRestartHandler.class);
    @Autowired
    private OctopusBatchService octopusBatchService;

    @Override
    public OctopusBatchRestartResponse handle(OctopusBatchRestartRequest request) throws OctopusBatchException {
        log.debug("Octopus Batch Restart, operator:{}, jobExecutionId:{}", (Object)request.getOperator(), (Object)request.getJobExecutionId());
        if (request.getJobExecutionId() == null) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OctopusBatchRestartResponse response = (OctopusBatchRestartResponse)request.createResponse();
        Long jobExecutionId = this.octopusBatchService.restart(request.getOperator(), request.getSystemId(), request.getJobExecutionId());
        response.setJobExecutionId(jobExecutionId);
        return response;
    }
}

