/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartByJobNameRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchRestartByJobNameResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OctopusBatchRestartByJobNameHandler
extends AbstractOctopusBatchHandler<OctopusBatchRestartByJobNameRequest, OctopusBatchRestartByJobNameResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchRestartByJobNameHandler.class);
    @Autowired
    private OctopusBatchService octopusBatchService;

    @Override
    public OctopusBatchRestartByJobNameResponse handle(OctopusBatchRestartByJobNameRequest request) throws OctopusBatchException {
        log.debug("Octopus Batch Restart By JobName, operator:{}, jobName:{}", (Object)request.getOperator(), (Object)request.getJobName());
        if (!StringUtils.hasLength((String)request.getJobName())) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OctopusBatchRestartByJobNameResponse response = (OctopusBatchRestartByJobNameResponse)request.createResponse();
        Long jobExecutionId = this.octopusBatchService.restartByJobName(request.getOperator(), request.getSystemId(), request.getJobName());
        response.setJobExecutionId(jobExecutionId);
        return response;
    }
}

