/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchAbandonRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchAbandonResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OctopusBatchAbandonHandler
extends AbstractOctopusBatchHandler<OctopusBatchAbandonRequest, OctopusBatchAbandonResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchAbandonHandler.class);
    @Autowired
    private OctopusBatchService octopusBatchService;

    @Override
    public OctopusBatchAbandonResponse handle(OctopusBatchAbandonRequest request) throws OctopusBatchException {
        log.debug("Octopus Batch Abandon, operator:{}, jobExecutionId:{}", (Object)request.getOperator(), (Object)request.getJobExecutionId());
        if (request.getJobExecutionId() == null) {
            throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobExecutionId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OctopusBatchAbandonResponse response = (OctopusBatchAbandonResponse)request.createResponse();
        OctopusBatchJobExecution jobExecution = this.octopusBatchService.abandon(request.getOperator(), request.getSystemId(), request.getJobExecutionId());
        response.setJobExecution(jobExecution);
        return response;
    }
}

