/*
 * Decompiled with CFR 0.152.
 */
package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchOperateRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchOperateResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchActivator;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusSkeletonBatchBadRequestException;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.ClassUtils;

@MessageEndpoint
public class OctopusBatchOperatorActivator
extends AbstractOctopusBatchActivator<OctopusBatchOperateRequest<OctopusBatchOperateResponse>, OctopusBatchOperateResponse> {
    private static final Logger log = LoggerFactory.getLogger(OctopusBatchOperatorActivator.class);

    @ServiceActivator(inputChannel="octopusSkeletonBatchOperateChannel")
    public OctopusBatchOperateResponse activate(OctopusBatchOperateRequest<OctopusBatchOperateResponse> request) {
        log.info("activate OctopusBatchOperateRequest, requestName:{}, systemId:{}, jobName:{}, jobExecutionId:{}", new Object[]{ClassUtils.getUserClass(request).getName(), request.getSystemId(), request.getJobName(), request.getJobExecutionId()});
        log.debug("activate OctopusBatchOperateRequest:{}", request);
        OctopusBatchOperateResponse response = null;
        try {
            response = (OctopusBatchOperateResponse)this.doActivate(request);
        }
        catch (OctopusSkeletonBatchBadRequestException e) {
            response = (OctopusBatchOperateResponse)request.createResponse();
            response.setRespCode(BatchRespCodeEnum.BAD_REQUEST.getRespCode());
            response.setRespDesc(e.getLocalizedMessage());
        }
        log.debug("activate OctopusBatchOperateResponse:{}", (Object)response);
        log.info("activate OctopusBatchOperateResponse, responseName:{}, respCode:{}, respDesc:{}", new Object[]{ClassUtils.getUserClass((Object)response).getName(), response.getRespCode(), response.getRespDesc()});
        return response;
    }

    @Override
    public OctopusBatchOperateResponse responseWithException(OctopusBatchOperateRequest<OctopusBatchOperateResponse> request, Exception exception) {
        OctopusBatchOperateResponse response = (OctopusBatchOperateResponse)request.createResponse();
        if (exception instanceof OctopusBatchException) {
            response.setRespCode(((OctopusBatchException)exception).getRespCode());
            response.setRespDesc(((OctopusBatchException)exception).getRespDesc());
        } else {
            response.setRespCode(BatchRespCodeEnum.SYSTEM_ERROR.getRespCode());
            response.setRespDesc(exception.getLocalizedMessage());
        }
        return response;
    }

    @Override
    public Object insertJournal(OctopusBatchOperateRequest<OctopusBatchOperateResponse> request) {
        return null;
    }

    @Override
    public void updateJournal(Object journal, AbstractOctopusBatchHandler<OctopusBatchOperateRequest<OctopusBatchOperateResponse>, OctopusBatchOperateResponse> handler, OctopusBatchOperateResponse response) {
    }
}

