package org.krproject.ocean.skeletons.octopus.batch.service;

import java.util.List;
import java.util.Set;

import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecution;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobExecutions;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInfo;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstance;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchJobInstances;
import org.krproject.ocean.skeletons.octopus.batch.api.model.OctopusBatchStepExecution;

/**
 * Octopus批量服务接口.
 * @author zhongyang
 *
 */
public interface OctopusBatchService {
	
	//获取所有批量标识码
	Set<String> getSystemIds();
	
	//获取所有批量作业
	List<OctopusBatchJobInfo> getJobInfos();
	
	//启动批量
	Long start(String operateUser, String systemId, String jobName, String parameters, Boolean checkLastJob);
	
	//重启批量
	Long restart(String operateUser, String systemId, long executionId);
	
	//根据批量名重启批量
	Long restartByJobName(String operateUser, String systemId, String jobName);
	
	//停止批量
	boolean stop(String operateUser, String systemId, long executionId);
	
	//废弃批量
	OctopusBatchJobExecution abandon(String operateUser, String systemId, long jobExecutionId);
	
	//启动下一个批量实例
	Long startNextInstance(String operateUser, String systemId, String jobName, Boolean chkLastJob);
	
	//根据批量名获取所有批量实例
	OctopusBatchJobInstances getJobInstances(String systemId, String jobName, int start, int count);
	
	//根据Job执行ID获取执行信息
	OctopusBatchJobExecution getJobExecution(String systemId, Long executionId);
	
	//获取Step执行信息
	OctopusBatchStepExecution getStepExecution(String systemId, Long jobExecutionId, Long stepExecutionId);
	
	//根据实例ID获取实例信息
	OctopusBatchJobInstance getJobInstance(String systemId, Long instanceId);
	
	//根据实例ID获取执行信息
	List<OctopusBatchJobExecution> getJobExecutions(String systemId, Long instanceId);
	
	//根据JobName获取执行信息
	OctopusBatchJobExecutions getJobExecutionsByJobName(String systemId, String jobName, int jobStart, int jobCount);
	
	//根据批量名获取正在执行的执行信息
	Set<OctopusBatchJobExecution> findRunningJobExecutions(String systemId, String jobName);

}
