package org.krproject.ocean.skeletons.octopus.batch.exception;

import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;

/**
 * 批量服务异常.
 * @author zhongyang
 *
 */
@SuppressWarnings("serial")
public class OctopusBatchException extends RuntimeException {
	
	public OctopusBatchException(BatchRespCodeEnum respCode, String respDesc) {
		super(respDesc);
		this.respCode = respCode.getRespCode();
		this.respDesc = respDesc;
	}

	/**
	 * 响应码.
	 */
	private final String respCode;
	
	/**
	 * 响应描述.
	 */
	private final String respDesc;

	
	public String getRespCode() {
		return this.respCode;
	}

	public String getRespDesc() {
		return this.respDesc;
	}

}
