package org.krproject.ocean.skeletons.octopus.batch.event;

import java.util.Date;

import org.krproject.ocean.skeletons.octopus.batch.api.OctopusBatchRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.OctopusBatchResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.springframework.context.ApplicationEvent;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * Octopus批量联机请求处理完成事件.
 * @author zhongyang
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
@SuppressWarnings("serial")
public class OctopusBatchCompletedEvent extends ApplicationEvent {

	public OctopusBatchCompletedEvent(Object source,
			String instanceId,
			OctopusBatchRequest<?> request,
			Date requestTime,
			AbstractOctopusBatchHandler<?, ?> handler,
			OctopusBatchResponse response,
			Date responseTime) {
		super(source);
		this.instanceId = instanceId;
		this.request = request;
		this.requestTime = requestTime;
		this.handler = handler;
		this.response = response;
		this.responseTime = responseTime;
	}
	
	// 实例编号
	private String instanceId;
	
	// 批量请求
	private OctopusBatchRequest<?> request;
	
	// 批量请求时间
	private Date requestTime;
	
	// 批量交易处理器
	private AbstractOctopusBatchHandler<?, ?> handler;
	
	// 批量响应
	private OctopusBatchResponse response;
	
	// 批量响应时间
	private Date responseTime;

}
