package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStartNextInstanceRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStartNextInstanceResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 启动下一个批量实例.
 * <p>批量参数由JobIncrementer生成,建议使用该方式启动批量,保证批量参数执行可控</p>
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchStartNextInstanceHandler extends AbstractOctopusBatchHandler<OctopusBatchStartNextInstanceRequest, OctopusBatchStartNextInstanceResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchStartNextInstanceResponse handle(OctopusBatchStartNextInstanceRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Start NextInstance, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		
		//组装响应
		OctopusBatchStartNextInstanceResponse response = request.createResponse();
		
		//启动批量
		Long jobExecutionId = this.octopusBatchService.startNextInstance(request.getOperator(), request.getSystemId(), request.getJobName(), request.getCheckLastJob());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
