package org.krproject.ocean.skeletons.octopus.batch.endpoint.operate.handler;

import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStartRequest;
import org.krproject.ocean.skeletons.octopus.batch.api.operate.OctopusBatchStartResponse;
import org.krproject.ocean.skeletons.octopus.batch.endpoint.AbstractOctopusBatchHandler;
import org.krproject.ocean.skeletons.octopus.batch.exception.OctopusBatchException;
import org.krproject.ocean.skeletons.octopus.batch.service.OctopusBatchService;
import org.krproject.ocean.vitamins.batch.api.enums.BatchRespCodeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * 启动批量.
 * <p>批量参数外传,不会执行批量的JobIncrementer</p>
 * @author zhongyang
 *
 */
@Slf4j
@Component
public class OctopusBatchStartHandler extends AbstractOctopusBatchHandler<OctopusBatchStartRequest, OctopusBatchStartResponse> {
	
	@Autowired
	private OctopusBatchService octopusBatchService;

	@Override
	public OctopusBatchStartResponse handle(OctopusBatchStartRequest request) throws OctopusBatchException {
		
		log.debug("Octopus Batch Start, operator:{}, jobName:{}", request.getOperator(), request.getJobName());
		
		//请求校验
		if (!StringUtils.hasLength(request.getJobName())) {
			throw new OctopusBatchException(BatchRespCodeEnum.BAD_REQUEST, "JobName不能为空");
		}
		
		//组装响应
		OctopusBatchStartResponse response = request.createResponse();
		
		//启动批量
		Long jobExecutionId = this.octopusBatchService.start(request.getOperator(), request.getSystemId(), request.getJobName(), request.getParameters(), request.getCheckLastJob());
		
		response.setJobExecutionId(jobExecutionId);
		
		return response;
	}

}
